#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// kaliuresis - color variationMod01.fsh    by   najibxy  
//https://www.shadertoy.com/view/MfycDV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed   //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Color variation from kaliuresis 

#define halfsqrt3 0.86602540
#define invsqrt3 0.57735026
#define tau 6.28318530
#define pi 3.14159265358979323846264338327950

float hash1D(vec2 x) {
    // hash by Inigo Quilez, Integer Hash - III, 2017
    uvec2 q = uvec2(x * 65536.0);
    q = 1103515245u * ((q >> 1u) ^ q.yx);
    uint n = 1103515245u * (q.x ^ (q.y >> 3u));
    return float(n) * (1.0 / float(0xffffffffu));
}

vec2 hash2D(vec2 x) {
    // based on: Inigo Quilez, Integer Hash - III, 2017
    uvec4 q = uvec2(x * 65536.0).xyyx + uvec2(0u, 3115245u).xxyy;
    q = 1103515245u * ((q >> 1u) ^ q.yxwz);
    uvec2 n = 1103515245u * (q.xz ^ (q.yw >> 3u));
    return vec2(n) * (1.0 / float(0xffffffffu));
}

float hash(vec2 x, float time) {
    return 0.5 + 0.5 * sin(tau * hash1D(x) + time);
}

// Value noise on a triangular lattice
float tri_noise(vec2 p, float time) {
    vec2 q = vec2(p.x - p.y * invsqrt3, p.y * 2.0 * invsqrt3);
    vec2 iq = floor(q);
    vec2 fq = fract(q);
    float v = 0.0;
    
    float h = step(1.0, fq.x + fq.y); // which half of the unit cell this triangle lies in
    vec2 c = iq + h;
    vec2 r = p - vec2(c.x + 0.5 * c.y, halfsqrt3 * c.y);
    float s = 1.0 - 2.0 * h;
    r *= s;
    
    // Compute barycentric coordinates
    vec3 lambda = vec3(1.0 - r.x - invsqrt3 * r.y, r.x - invsqrt3 * r.y, 2.0 * invsqrt3 * r.y);
    // Quintic smoothing
    vec3 lambda2 = lambda * lambda;
    vec3 a = 15.0 * lambda2 * lambda2.zxy * lambda.yzx;
    vec3 w = lambda * lambda2 * (10.0 - 15.0 * lambda + 6.0 * lambda2) + a + a.yzx;
    
    v += w.x * hash(abs(c), time);
    v += w.y * hash(abs(iq + vec2(1.0 - h, h)), time);
    v += w.z * hash(abs(iq + vec2(h, 1.0 - h)), time);
    
    return v;
}

float fbm(vec2 p, int octaves, float decay, float time) {
    vec2 fwp = fwidth(p);
    float w = dot(step(fwp.xy, fwp.yx), fwp);
    vec2 v = vec2(0.0);
    float weight = 1.0;
    for (int i = 0; i < octaves; i++) {
        v += weight * vec2(tri_noise(p, time) * smoothstep(1.0, 0.5, w), 1.0);
        p *= 2.0 * mat2(4.0 / 5.0, -3.0 / 5.0, 3.0 / 5.0, 4.0 / 5.0);
        w *= 2.0;
        weight *= decay;
        time *= 1.6;
    }
    return v.x / v.y;
}

float fcos(float x) {
    float w = fwidth(x);
    return cos(x) * sin(0.5 * w) / (0.5 * w);
}

float get_val(vec2 p) {
    float l = length(p);
    float wavf = 0.02;

    // Adjust time to slow down further and loop in 20 seconds
    float time = mod(iTime, 40.0) / 40.0 * tau; // Slow down: 40 seconds total loop time
    
    float w = fbm(5.0 * p + vec2(7.0), 3, 0.6, 0.01 * time);
    float angle = 0.12 * time - 1.0 / wavf * 0.005 * fcos(100.0 * l + wavf * time) 
                  - 2.5 * log(l + 0.01) - 0.5 * w;
    vec2 cs = vec2(cos(angle), sin(angle));
    p = vec2(p.x * cs.x - p.y * cs.y, p.x * cs.y + p.y * cs.x);
    
    vec2 up = 5.0 * p + vec2(7.0);
    float u = fbm(up, 6, 0.6, 0.01 * time) - 0.5;
    u = fcos(10.0 * u);
    vec2 vp = 2.0 * u + vec2(1.0);
    float v = fbm(vp, 3, 0.3, 10.0 + 0.1 * time);
    
    v += 20.0 * l * smoothstep(0.0, 0.02, l);
    return v;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - 0.5 * iResolution.xy) / iResolution.y;
    vec2 p = 0.1 * uv;
    float l = length(p);
    float v = get_val(p);
    
    fragColor = mix(vec4(0.682, 0.055, 0.506,1.0), 
                    vec4(0.627, 0.09, 0.188, 1),
                    smoothstep(1.5, 1.5, v));
    vec2 e = vec2(2.0 * dFdx(p.x), 0.0);
    vec3 grad = normalize(0.5 * vec3((get_val(p + e.xy) - get_val(p - e.xy)), 
                                     0.5 * (get_val(p + e.yx) - get_val(p - e.yx)), 
                                     10.0 * e.x));
    fragColor.rgb += vec3(0.5) * pow(clamp(dot(grad, normalize(vec3(1.0, 1.0, 1.0))), 0.0, 1.0), 10.0);
    fragColor.rgb += vec3(0.25, 0.0, 0.0) * pow(clamp(dot(grad, normalize(vec3(-1.0, 1.0, 1.0))), 0.0, 1.0), 10.0);
    fragColor.rgb *= smoothstep(-1.0, 0.0, 1.0 - v + 13.0 * l - 0.7);
    fragColor.rgb *= smoothstep(-0.1, 0.4, abs(v - 1.0));
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

